title convert a number to ascii. coded by wbinvd

        include segments.inc

        public  __ntoa

        startcode
;Convert a number in EAX to an ascii string in EDI
;In:    EAX     Number to convert to ascii
;       ECX     Minimum number of digits to print
;       BL      flags
;       BH      base (10b=binary,10o=octal,10d=decimal,10h=hex)
;       EDI     String to use
;Out:   EDI     String with number (NOT zero terminated!!!)
;       EAX     zero
;       ECX     # of digits we printed in EDI
;Regs:  EAX,ECX
__ntoa                  proc near
        push    edx ebp esi edi
        test    bl,signed
        jz      short @@10
        test    eax,eax
        jns     short @@10
        neg     eax                     ;make it positive
        mov     CharType ptr [edi],'-'
        jmp     short @@incedi
@@10:
        test    bl,showsign
        jz      short @@20
        mov     CharType ptr [edi],'+'
@@incedi:
ifdef UNICODE
        inc     edi
endif
        inc     edi
@@20:
        test    ecx,ecx
        jnz     short @@30
        inc     ecx
@@30:
        xor     esi,esi                 ;# of pushed dwords
        movzx   ebp,bh                  ;EBP=Base
@@pushloop:
        xor     edx,edx
        div     ebp
        push    edx
        inc     esi
        test    eax,eax
        jnz     short @@pushloop

        mov     edx,esi
        mov     ebp,ecx
        sub     ecx,esi
        jbe     short @@40
        mov     edx,ebp
        mov     al,'0'                  ;If UNICODE: AH already is 00h
;        rep stosb_                     ;TASM32 v5.0 BUG!!! Crashes.
        rep
        stosb_
@@40:
        mov     ecx,edx
        mov     dh,'0'
        mov     dl,'a'-('0'+10)
        test    bl,bighex
        jz      short @@no
        mov     dl,'A'-('0'+10)
@@no:
@@poploop:
        pop     eax                     ;EAX is max FFh
        add     al,dh
        cmp     al,'9'
        jbe     short @@50
        add     al,dl
@@50:
        mov     [edi],al_
ifdef UNICODE
        inc     edi
endif
        inc     edi
        dec     esi
        jg      short @@poploop
@@666:
        pop     edi esi ebp edx
        mov     al_,[edi]
        cmp     al_,'-'
        je      short @@60
        cmp     al_,'+'
        jne     short @@70
@@60:
        inc     ecx                     ;we printed a '+' or a '-' too!
@@70:
        xor     eax,eax
        retn
__ntoa                  endp
        endcode
        end
